#include <iostream>
#include <cstdio>
#include <string>
#include <cstring>
#include <map>
#include <set>
#include <stack>
#include <queue>
#include <vector>
#include <cmath>
#include <algorithm>
#include <ctime>
#include <cstdlib>
#include <cassert>

using namespace std;
#define forn(i, n) for (int i = 0; i < n; ++i)
#define ALL(a) a.begin(), a.end()
#define X first
#define Y second
#define sz(a) ((int)a.size())
#define L(a) sz(a)
#define pb(a) push_back(a)
#define mp(a, b) make_pair(a, b)
#define ms(a) memset(a,0,sizeof(a))
#define ms1(a) memset(a,-1,sizeof(a))

typedef long long ll;
typedef unsigned long long ull;
typedef long double ld;
typedef pair<int, int> pii;

const double PI = 3.1415926535897932384626433832795;

string s;

struct ret {
	double A, B, C;
	double x, y;
	bool ispoint;
	ret(double x, double y):x(x),y(y),ispoint(1) {}
	ret(double A, double B, double C):A(A),B(B),C(C),ispoint(0) {}
};

ret p2l(ret& r1, ret& r2) {
	double A = r2.y-r1.y;
	double B = r1.x-r2.x;
	double C = -(A*r1.x+B*r1.y);
	return ret(A,B,C);
}

ret pl(ret& p, ret& l) {
	double A = l.A;
	double B = l.B;
	double C = l.C;
	double k = -2*(A*p.x+B*p.y+C)/(A*A+B*B);
	return ret(p.x+k*A,p.y+k*B);
}

double det(double a11, double a12, double a21, double a22) {
	return a11*a22-a12*a21;
}

ret inters(ret& l1, ret& l2) {
	double d = det(l1.A,l1.B,l2.A,l2.B);
	double d1 = det(-l1.C,l1.B,-l2.C,l2.B);
	double d2 = det(l1.A,-l1.C,l2.A,-l2.C);
	return ret(d1/d,d2/d);
}

int stoi(string s) {
	int sgn = 1;
	if (s[0] == '-') sgn = -1, s.erase(0,1);
	int res = 0;
	forn(i, sz(s)) res = res * 10 + s[i]-'0';
	return res * sgn;
}

ret parse(int l, int r) {
	//cerr << s.substr(l,r-l+1) << "\n";
	int bal = 0;
	int mid = -1;
	int cnt = 0;
	for (int i = r; i >= l; --i) {
		if (s[i] == ')') bal++, ++cnt;
		else if (s[i] == '(') bal--, ++cnt;
		if (bal == 0 && cnt) {
			mid = i;
			break;
		}
	}
	if (cnt == 0) {
		string s1 = "", s2 = "";
		bool hasc = false;
		for(int i = l; i <= r; ++i) {
			if (s[i] == ',') hasc = true;
			else {
				if (!hasc) s1 += s[i];
				else s2 += s[i];
			}
		}
		return ret(stoi(s1), stoi(s2));
	}
	ret rg = parse(mid+1, r-1);
	if (mid == l) return rg;
	assert(s[mid-1] == '@');
	ret lf = parse(l, mid-2);
	if (!lf.ispoint) swap(lf, rg);
	if (!lf.ispoint) return inters(lf, rg);
	else if (rg.ispoint) return p2l(lf, rg);
	else return pl(lf, rg);
}

bool solve() {
	cin >> s;
	if (s == "#") return false;
	ret ans = parse(0,sz(s)-1);
	printf("%.15lf %.15lf\n", ans.x, ans.y);
	return true;
}

int main() {
#ifdef _DEBUG
	freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#else
	/*freopen("input.txt", "r", stdin);
	freopen("output.txt", "w", stdout);*/
#endif
	while(solve());
	return 0;
}
